	function a = TWOC_2_CSDC2(TwoCVector)

	% Converts a two's-complement number to Canonic Signed Digit Code (CSDC)
	
	%	EXAMPLE TWO_C = 1001
	%	CSDC =  [ 0  1  0   0   0   0   -1   0   1   0   0   1]
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Oscar Gustafsson
	% 	Modified by: 	 	
	%	Copyright:			by authors - not released for commercial use
	% 	Version:			1	 
	% 	Known bugs:			
	% 	Report bugs to:		Wanhammar@gmail.com
		
	TwoCVector = fliplr(TwoCVector);
	j = length(TwoCVector);
	if TwoCVector == [0]
	  a = zeros(1,j);
	else
	  phi(1) = TwoCVector(1);
	  eta(1) = phi(1);
	  a(1) = (1- 2*TwoCVector(2))*eta(1);
	  TwoCVector(j+1) = TwoCVector(j);
	  
	  for i=2:j;
	    phi(i) = xor(TwoCVector(i), TwoCVector(i-1));
	    eta(i) = and(not(eta(i-1)), phi(i));
	    a(i) = (1- 2*TwoCVector(i+1))*eta(i);
	  end
	end
	a = fliplr(a);
